#version 330
#extension GL_EXT_gpu_shader4 : enable
// truchet traveler 3dMod01.fsh  by  abje

//https://www.shadertoy.com/view/llSyzR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)
#define dir3(num) vec3(equal(abs(dir),vec3(num)))
//hash function by Dave_Hoskins https://www.shadertoy.com/view/4djSRW
vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yxz+19.19);
    return fract((p3.xxy + p3.yxx)*p3.zyx);
}

#define dot2(p) dot(p,p)

float torus(vec3 p, vec2 r) {//creates 4 toruses
    return length(vec2(abs(abs(length(p.xy)-r.x)-0.05),abs(p.z)-0.05))-r.y;
}

float map(vec3 p) {
    
    vec3 p2 = mod(p,2.0)-1.0;
    vec3 floorpos = floor(p*0.5);
    float len = 1e10;
    
    //the truchet flipping
    vec3 flipping = floor(hash33(floorpos)+0.5)*2.0-1.0;
    
    //actually flipping the truchet
    vec3 p3 = p2*flipping;
    
    //positions relative to truchet centers
    mat3 truchet = mat3(
        vec3(+p3.yz+vec2(-1.0, 1.0),p3.x),
        vec3(+p3.zx+vec2(-1.0, 1.0),p3.y),
        vec3(+p3.yx+vec2( 1.0,-1.0),p3.z)
    );
    
    //finding distance to truchet
    len = min(min(
        torus(truchet[0],vec2(1.0,0.01)),
        torus(truchet[1],vec2(1.0,0.01))),
        torus(truchet[2],vec2(1.0,0.01)));
    
    return len;
}

//normal calculation
vec3 findnormal(vec3 p, float len) {
    const vec2 eps = vec2(0.01,0.0);
    
    return normalize(vec3(
        len-map(p-eps.xyy),
        len-map(p-eps.yxy),
        len-map(p-eps.yyx)));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (gl_FragCoord.xy * 2.0 - iResolution.xy) / iResolution.y;
    
    vec3 floorpos = vec3(0.0,0.0,0.0);
    vec3 pos = vec3(1.0,1.0,0.0);
    vec3 dir = vec3(3.0,2.0,1.0);
    int num = 2;
    float time = iTime*0.4;
    for (float i = 0.0; i <= floor(time); i++) {
        
        pos += dir*dir3(1);
        
    	vec3 flipping = floor(hash33(floorpos)+0.5)*2.0-1.0; //the truchet flipping
        
        dir *= flipping;
        
        int num2 = (num-int(dot(dir,dir3(1)))+3)%3;
        float back = dir[num2];
        dir[num2] = dir[num];
        dir[num] = -back;
        num = num2;
        
        dir *= flipping;
        
        floorpos += dir*dir3(1);
        pos += dir*dir3(1);
    }
	
    vec3 flipping = floor(hash33(floorpos)+0.5)*2.0-1.0; //the truchet flipping
    vec3 dir2 = dir;
    
    dir *= flipping;
    
    int num2 = (num-int(dot(dir,dir3(1)))+3)%3;
    float back = dir[num2];
    dir[num2] = dir[num];
    dir[num] = -back;
    num = num2;
    
    dir *= flipping;
	
    //animation
    pos += dir2*vec3(equal(abs(dir2),vec3(1.0)))*(sin(fract(time)*3.14*0.5));
    pos += dir*dir3(1)*(1.0-cos(fract(time)*3.14*0.5));
    
    //normal pointing towards where the camera moves, would be nice if the camera was looking in that direction
    vec3 forward = dir2*vec3(equal(abs(dir2),vec3(1.0)))*cos(fract(time)*3.14*0.5)+dir*dir3(1)*sin(fract(time)*3.14*0.5);
    
    /*
    mat3 rotation = mat3(
        vec3(0.0),
        vec3(0.0),
        vec3(0.0));
    rotation[2] = forward;
    rotation[1] = normalize(cross(forward,vec3(1)));
    rotation[0] = cross(rotation[1],forward);
    */
    
    mat3 rotation = mat3(
        vec3(0.0),
        vec3(0.0),
        vec3(0.0));
    
    vec2 t = vec2(cos(fract(time)*3.14*0.5),sin(fract(time)*3.14*0.5));
	rotation[2] = normalize(dir2*vec3(equal(abs(dir2),vec3(1)))*t.x+dir*dir3(1)*t.y);
    rotation[1] = normalize(dir2*vec3(equal(abs(dir2),vec3(2)))*t.x+dir*dir3(2)*t.y);
    rotation[0] = normalize(dir2*vec3(equal(abs(dir2),vec3(3)))*t.x+dir*dir3(3)*t.y);
    
    
    
    vec3 ro = pos+rotation[1]*0.125;
    vec3 rd = normalize(vec3(uv,1.0));
    
    rd = normalize(uv.x*rotation[0]+uv.y*rotation[1]+rotation[2]);
    
    bool hit = false;
    float len;
    float dist = 0.0;
    for (int i = 0; i < 50; i++) {
        len = map(ro);
        if (len < 0.01||dist>10.0) {
            hit = len < 0.01;
            break;
        }
        ro += rd*len;
        dist += len;
    }
    if (hit) {
        
		gl_FragColor = vec4(findnormal(ro,len)*0.5+0.5,1.0);
        gl_FragColor /= (dist*dist*0.05+1.0);
        //if (all(equal(floor(ro*0.5),floorpos))) gl_FragColor = 1.0-gl_FragColor;
    }
}